class Dialog: UIFrame
{
TagGroup DLGTags, MyStringField, MyPushButton
void init(object self)
	{
	DLGTags = DLGCreateDialog("Acquire 2 images").DLGTableLayout(2,5,0)

	DLGTags.DLGAddElement(DLGCreateLabel("detector"))
	number signalIndex =0
	DLGTags.DLGAddElement(DLGCreateIntegerField(signalIndex, 8).DLGIdentifier("signalIndex"))

	DLGTags.DLGAddElement(DLGCreateLabel("ini orientation"))
	number iniOrient=0
	DLGTags.DLGAddElement(DLGCreateRealField(iniOrient, 8,2).DLGIdentifier("IniOrient"))

	DLGTags.DLGAddElement(DLGCreateLabel("width"))
	number Width=1024
	DLGTags.DLGAddElement(DLGCreateIntegerField(Width, 8).DLGIdentifier("Width"))

	DLGTags.DLGAddElement(DLGCreateLabel("dwell (usec)"))
	number Dwell=1
	DLGTags.DLGAddElement(DLGCreateRealField(Dwell, 8,2).DLGIdentifier("Dwell"))

	DLGTags.DLGAddElement(DLGCreatePushButton("ACQUIRE", "acquire_store").DLGAnchor("East"))
	number No=1
	DLGTags.DLGAddElement(DLGCreateIntegerField(No, 3).DLGIdentifier("No"))

	self.init(DLGTags)
	self.display("Acquire || STEM =");
	}

void store(object self,image im,string filename)
	{
	if(!DoesFileExist(filename))
		{
		saveimage(im,filename)

		}
	else
		{
		string filename_
		if (!SaveAsDialog("File exist. Overwrite?", filename, filename_)) Exit(0)
		}
	ImageDocument imdoc =ImageGetOrCreateImageDocument(im)	
	ImageDocumentClean(imdoc)
	}

image acquire(object self,number Width, string Name, number ParamID)
	{
	number continuous  = 0 // 0 = single frame, 1 = continuous
    number synchronous = 0 // 0 = return immediately, 1 = return when finished
	image im := integerimage("",4,0,Width,Width)	//prepare the original image
	number imageID = ImageGetID(im)
	im.showimage()
	im.setName(Name)	    
	DSSetParametersSignal(paramID, 0, 4, 1, imageID)
	DSStartAcquisition(paramID, continuous, synchronous)	
	while(DSIsAcquisitionActive() )
	yield()
	return im
	}
	
void acquire_store(object self)
	{
	// read parameters 
	number signalIndex =self.LookUpElement("signalIndex").DLGgetValue() //employed detector, can be 0,1...
	number iniOrient =self.LookUpElement("IniOrient").DLGgetValue() // initial orientation in degree
	number Width =self.LookUpElement("Width").DLGgetValue() //size in pixels
	number Dwell =self.LookUpElement("Dwell").DLGgetValue() // dwell time in microseconds
	number No =self.LookUpElement("No").DLGgetValue() // sequential number of acquisition

	number lineSync = 1 // activated line synchronization
	number paramID_1 = DSCreateParameters( Width, Width, iniOrient, Dwell, lineSync)
	number paramID_2 = DSCreateParameters( Width, Width, iniOrient+90, Dwell, lineSync)
	number continuous  = 0 // 0 = single frame, 1 = continuous
    number synchronous = 0 // 0 = return immediately, 1 = return when finished
    	
	DSstopacquisition(-1)	//stop all currently executed operatrions of Digiscan

	//acquire both images
	image im1 := self.acquire(Width, "original "+No, ParamID_1)
	image im2 := self.acquire(Width, "rotated "+No, ParamID_2)

	// prepare sub-folder for storing rortation series if not exist
	string currentDir = GetApplicationDirectory(0,0) // current open_save folder
	string subDir = currentDir + "rotated series"
	subdir =PathConcatenate(subdir,"") //to add / at the end
	SetApplicationDirectory("open_save", 1, subDir ) //create subfolder if not exist
	
	//store both images in sub-folder
	string ext = ".dm4"
	string name1 = No+"_O"
	string name2 =No+"_R"
	self.store(im1,subdir + name1 +ext)
	self.store(im2,subdir + name2 +ext)
		
	//update counter file
	number fileID = CreateFileForWriting(subdir+"counter.txt")
	writeFile(fileID, ""+No)
	closeFile(fileID)
	
	SetApplicationDirectory("open_save", 0, currentDir ) //return to initial folder
	
	//increment the acquisition sequential number
	No++
	result("\n"+No)
	self.LookUpElement("No").DLGValue(No)
	}
}
Object DialogInstance = alloc(Dialog)
DialogInstance.init()