
/*********** Truncate original extension *******************/
string TrunctateFileExtension112(string Name, number extraSymb)
	{
	string Ext = PathExtractExtension(Name,0)
	
	return left(name,len(name)-len(ext)-extraSymb)	
	}


/**********************************************************************
Import TIA functions
**********************************************************************/
TagGroup ReadTagFromStream112(object stream,string TagType)
	{
	TagGroup tg = NewTagGroup(); 
		if(TagType=="UInt16_0") tg.TagGroupSetTagAsUInt16(TagType, 0 )
		if(TagType=="SInt32_0") tg.TagGroupSetTagAsLong(TagType, 0 )
		if(TagType=="Double") tg.TagGroupSetTagAsDouble(TagType, 0 )
 	TagGroupReadTagDataFromStream( tg,TagType, stream,2); 
 	
 	return Tg
	}


number  read112Int16(object stream)
	{
	string TagType = "UInt16_0"
	number value 
  	ReadTagFromStream112(stream,TagType).TagGroupGetTagAsUInt16(TagType, value)  

	return value
	}
	
number  read112Int32(object stream)
	{
	string TagType = "SInt32_0"
	number value
  	ReadTagFromStream112(stream,TagType).TagGroupGetTagAsLong(TagType, value)  
  	
	return value
	}

number  read112Double(object stream)
	{
	string TagType = "Double"
	number value
	ReadTagFromStream112(stream,TagType).TagGroupGetTagAsDouble(TagType, value) 
	  	
	return value
	}

number IntType112(number typeCode)
	{
	if(typeCode ==1) return 1
	if(typeCode ==2) return 2
	if(typeCode ==3) return 4	
	if(typeCode ==4) return 1
	if(typeCode ==5) return 2
	if(typeCode ==6) return 4	
	}
	
number IntSign112(number typeCode)
	{
	if(typeCode <=3) return 0
	if(typeCode >3) return 1	
	}
	
image ConvertSerImage112(string path)
	{
	//make a stream
	number fileID=openfileforreading(path)
	object stream
	stream=NewStreamFromFileReference(fileID,1)  
	
	//header
	number OffsetDataTypeID =6
	stream.StreamSetPos(0,OffsetDataTypeID ) 	
	number DataTypeID  = stream.read112Int32()
	//result("\nDataTypeID  "+DataTypeID )

	number OffsetArrayOffset = 22	
	stream.StreamSetPos(0,OffsetArrayOffset) 	
	number ArrayOffset = stream.read112Int32()
	stream.StreamSetPos(0,ArrayOffset)
	number DataOffset = stream.read112Int32()
	
	if(DataTypeID ==16674) //scanned image
		{
		number OffsetCalX = 8
		number OffsetCalY = 28
		number offsetType = 40
		number OffsetW =42
		number OffsetH =46

		//read parameters: width,height, calibration
		stream.StreamSetPos(0,DataOffset+OffsetCalX)
		number calX = stream.read112Double()*1000000000
		stream.StreamSetPos(0,DataOffset+OffsetCalY)
		number calY = stream.read112Double()*1000000000
		stream.StreamSetPos(0,DataOffset+offsetType)
		number type = stream.read112Int16()
		stream.StreamSetPos(0,DataOffset+OffsetW)
			result("\ calX "+calX	+" calY "+calY+" type "+type)
		number w = stream.read112Int32()
		stream.StreamSetPos(0,DataOffset+OffsetH)
		number h = stream.read112Int32()
			//result(" "+w+"x"+h)

		//read array (starts immediately after height
		//only integer types are coded for the moment
		number Bytes =IntType112(type)
		number Sign =IntSign112(type)
		image im:=integerimage("",Bytes,Sign,w,h)
		ImageReadImageDataFromStream(im,stream,2) 

		//calibrate
		ImageSetDimensionCalibration(im,0,0,calX,"nm",1)
		ImageSetDimensionCalibration(im,1,0,calY,"nm",1)

		return im
		}
		
	if(DataTypeID ==16672) //spectrum
		{
		number OffsetCalX = 8
		number offsetType = 20
		number OffsetL =22
		
		stream.StreamSetPos(0,DataOffset+OffsetCalX)		
		number calX = stream.read112Double()/1000

		stream.StreamSetPos(0,DataOffset+offsetType)
		number type = stream.read112Int16()
	
		stream.StreamSetPos(0,DataOffset+OffsetL)
		number length = stream.read112Int32()
		result("\ calX "+calX	+" type "+type+" length "+length)
		
		//read spectrum
		//only integer types are coded for the moment
		number Bytes =IntType112(type)
		number Sign =IntSign112(type)	
		image im:=integerimage("",Bytes,Sin,length)
		ImageReadImageDataFromStream(im,stream,2) 	
		
		//calibrate
		ImageSetDimensionCalibration(im,0,0,calX,"keV",1)
		
		return im
		}		
	}


image ReshapeSerImage112(image im)
	{
//result("\npath #"+path+" #"+name)	

	number w,h,minI,maxI
	getSize(im,w,h)
	minI = min(im)
	maxI = max(im)
	
	image imR := imageclone(im)
	imR =(im-minI)/(maxI-minI)*32767
	
	imR = im[icol,h-irow]
	
	return imR
	}	


/**********************************************************************
Import TIFF functions
**********************************************************************/
	number ReadValueOfTypeBSCH(object fStream, string type, number byteOrder)
	{	//function by B Schaffer 
		number val = 0
		TagGroup tg = NewTagGroup()
		if ( type == "bool" )
		{
			tg.TagGroupSetTagAsBoolean( type, 0 )
			tg.TagGroupReadTagDataFromStream( type, fstream, byteOrder ) 
			tg.TagGroupGetTagAsBoolean( type, val )
		}
		else if ( type == "uint16" )
		{
			tg.TagGroupSetTagAsUInt16( type, 0 )
			tg.TagGroupReadTagDataFromStream( type, fstream, byteOrder ) 
			tg.TagGroupGetTagAsUInt16( type, val )
		}
		else if ( type == "uint32" )
		{
			tg.TagGroupSetTagAsUInt32( type, 0 )
			tg.TagGroupReadTagDataFromStream( type, fstream, byteOrder ) 
			tg.TagGroupGetTagAsUInt32( type, val )
		}
		else Throw("Invalid read-type:"+type)
		
	return val
	}
	
	
string readASCIfromStream112(object fStream,number dataOffset,number length,number byteOrder)
	{
	string txt
	
	number currentPos = fStream.StreamGetPos()
	fStream.StreamSetPos( 0, dataOffset )
	txt = fStream.StreamReadAsText(0,length)
	fStream.StreamSetPos( 0, currentPos )

	return txt
	}


number readIEEE754(object fStream,number byteOrder)
	{
	number word
	string w3,w4
	number fract1,fract2,expo,signn 
	
	for(number i=1;i<=2;i++)	//first two words ignored, no need double precision
		{
		word = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder )
		}
		
	word = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder ) //3rd word
	w3 = binary(word,16)
//result("\n"+word+" ")
	for(number j=16;j>=1;j--)
		{
		number n = val(w3.left(1))
		fract2 += n*2**(j-21)
		w3 = w3.right(len(w3)-1)
		}
//result(" fract2 "+ fract2)
		
	word = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder ) //4th word
	w4 = binary(word,16)
//result("\n"+word+" "+w4)
	for(number j=16;j>=1;j--)
		{
		number n = val(w4.left(1))
		
		if(j==16)	//1st bit: sign,
			{
			if(n==1) 
				{
				signn = (-1);
				}
			else 
				{
				signn = 1;
				}
			}
		if((j<16)&&(j>=5)) //next 11 bit: exp
			{
			expo += n*2**(j-5) 
			}
		if(j<5) // 4bit: major fraction
			{
			fract1 += n*2**(j-5)
			}
		w4 = w4.right(len(w4)-1)
		}
//result(" fract1 "+ fract1)

	expo -= 1023 //std bias
	number fract = 1+fract1+fract2 //+ fract2*65536
	number coded = fract*2**expo
//result("\nfract1 "+fract1 +" fract2 "+fract2+" fract "+fract +" exp "+expo+" coded "+coded)	

	return coded
	}
	
	
string ReadTiffTags112(string path,string &extractedText)
	{//modified Schaffers's function
			
		// Open Stream 
		number fileID = OpenFileForReading( path )
		object fStream = NewStreamFromFileReference(fileID,1)
		
		// Read data byte order. (1 = big Endian, 2= little Endian for Gatan)
		number val
		number byteOrder = 0
		val = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder )
		byteOrder = ( 0x4949 == val  ) ? 2 : ( 0x4D4D == val ? 1 : 0 )
//Result("\n TIFF endian:"+byteOrder)
		
		// Verify TIFF image
		val = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder )
		if ( val != 42 ) return "NON TIFF" 

		string Manufacturer
		string info
		
		number IFDstart,pixEnd,marker,Width,Height
		
		// Browse IFD
		number offset = fStream.ReadValueOfTypeBSCH( "uint32", byteOrder )
		IFDstart = offset
		
		while( 0 != offset )
		{
		fStream.StreamSetPos( 0, offset ) // Start of IFD
		number nEntries = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder )
		
		for ( number e=0;e<nEntries;e++)
			{
			number tag 		  = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder )
			number typ 		  = fStream.ReadValueOfTypeBSCH( "uint16", byteOrder )
			number count 	  = fStream.ReadValueOfTypeBSCH( "uint32", byteOrder )
			number dataOffset = fStream.ReadValueOfTypeBSCH( "uint32", byteOrder )
//Result("\n entry # "+e+": ID["+tag+"]\ttyp="+typ+"\tcount="+count+"\t offset @"+dataOffset)
			
			
			if (256 == tag  ) Width = dataOffset
			if (257 == tag  ) Height = dataOffset
			if (273 == tag  ) pixEnd = dataOffset 
			if (33560== tag  ) marker = dataOffset
			
			if (34118 == tag ) // Zeiss
				{
//Result("\nZeiss")
				Manufacturer = "Zeiss"
				number currentPos = fStream.StreamGetPos()
				fStream.StreamSetPos( 0, dataOffset )
				extractedText = fStream.StreamReadAsText( 0, count )
				fStream.StreamSetPos( 0, currentPos )
				}
				
			if (34682 == tag ) // FEI
				{
//Result("\nZeiss")
				Manufacturer = "FEI"
				number currentPos = fStream.StreamGetPos()
				fStream.StreamSetPos( 0, dataOffset )
				extractedText = fStream.StreamReadAsText( 0, count )
				fStream.StreamSetPos( 0, currentPos )
				}
	
			//AnalySiS
			if (305 == tag ) //software
				{
				number currentPos = fStream.StreamGetPos()
				info = readASCIfromStream112(fStream,dataOffset,count-1,byteOrder)
				if(info = "analySIS 3.1")
//result(" extracted #"+info+"#")
					{
					number caloffset = dataOffset +26
					fStream.StreamSetPos( 0, caloffset )
					extractedText += "\nPixel Size X = "+readIEEE754(fStream,byteOrder)
					extractedText += ""
					extractedText += "\nPixel Size Y = "+readIEEE754(fStream,byteOrder)
					extractedText += "\n"
					
					manufacturer = "AnalySIS"	
					}
					
				fStream.StreamSetPos( 0, currentPos )
				}
	
			}
			
		offset = fStream.ReadValueOfTypeBSCH( "uint32", byteOrder ) // this is 0000 for the last directory according to spec
		}
		
	return Manufacturer
	}
	
	String TruncWhiteSpaceBeforeAndAfterBSCH( string input )
	{ 	//function by B Schaffer 
		string work = input
		if ( len(work) == 0 ) return ""
		while ( " " == left(work,1) )
			{
			work = right( work, len(work) - 1 )
			if ( len(work) == 0 ) return ""	
			}
		while ( " " == right(work,1) )
			{
			work = left( work, len(work) - 1 )
			if ( len(work) == 0 ) return ""	
			}
			
	return work
	}

	TagGroup CreateTagsFromStringBSCH( string input )
	{	//function by B Schaffer 
	// INPUT:  String with line-wise information
	// OUTPUT: TagGroup
	// Assumptions:  
	//	- Groups are specified in a line in the format:				[GroupName]
	//	- The string contains information line-wise in the format:	KeyName=Vale

		TagGroup tg = NewTagGroup()
		string work = input
		
		string eoL 			= "\n"
		string GroupLeadIn	= "["
		string GroupLeadOut = "]"
		string keyToValueSep= "="
		string groupName = ""
		
		number pos = find(work,eoL )
		while( -1 != pos )
		{
			string line = left(work,pos)
			work = right(work,len(work)-pos-len(eoL))
			number leadIn  = find(line,GroupLeadIn)
			number leadOut = find(line,GroupLeadOut)
			number sep = find(line,keyToValueSep)
			if ( ( -1 < leadIn ) && ( -1 < leadOut ) && ( leadIn < leadOut ) ) // Is it a new group? "[GROUPNAME]"
			{
				groupName = mid(line,leadIn+len(GroupLeadIn),leadOut-leadIn-len(GroupLeadOut))
				groupName = TruncWhiteSpaceBeforeAndAfterBSCH(groupName)
			}
			else if( -1 < sep )													// Is it a value? "KEY=VALUE" ?
			{
				string key  = left(line,sep)
				string value= right(line,len(line)-sep-len(keyToValueSep))
				key   = TruncWhiteSpaceBeforeAndAfterBSCH(key)
				value = TruncWhiteSpaceBeforeAndAfterBSCH(value)
				string tagPath = groupName + ( "" == groupName ? "" : ":" ) + key
				tg.TagGroupSetTagAsString( tagPath, value )
			}
			pos = find(work,eoL)		
		}
		return tg
	}


image ImportTIFFWithTags112(string path)
	{	
	string extractedText
	string manufacturer = ReadTiffTags112(path,extractedText)
//result("\nmanufacturer:"+Manufacturer)
		
	tagGroup infoAsTags = CreateTagsFromStringBSCH(extractedText )

	// Import data and add info-tags
	image imported := OpenImage(path)
	string Name = imported.ImageGetName()
	imported.ImageGetTagGroup().TagGroupSetTagAsTagGroup(manufacturer,infoAsTags)


		// Calibrate image, if info is found
		// It seems FEI stores this value as [m] in the tags PixelHeight and PixelWidth
		// while ZEISS images contain the size of the FOV in the tags "Height" and "Width" as string including unit
	number scaleX = 0
	number scaleY = 0
	string unitX 
	string UnitY
	
	if(Manufacturer=="FEI")
		{
		unitX = "nm"
		unitY = "nm"
		if(imported.GetNumberNote(Manufacturer+":Scan:PixelWidth", scaleX ) )
			{	
			scaleX *= 1e9
			}
		if (imported.GetNumberNote(Manufacturer+":Scan:PixelHeight", scaleY ) )
			{		
			scaleY *= 1e9
			}
		}
		
	if(Manufacturer=="Zeiss")
		{
		string pixelInfo
		if (imported.GetStringNote(Manufacturer+":Pixel Size", pixelInfo) )
			{
			number pos = find( pixelInfo, " " )
			if ( -1 < pos )
				{
				scaleX = val( left(pixelInfo,pos) )
				unitX  = right( pixelInfo, len(pixelInfo)-pos-1 )
				}
			}
		else
			{
			string widthInfo
			if(imported.GetStringNote( "Imported TIFF Tags:Width", widthInfo) )
				{
				number pos = find( widthInfo, " " )
				if ( -1 < pos )
					{
					scaleX = val( left(widthInfo,pos) )
					scaleX /= imported.ImageGetDimensionSize(0)
					unitX  = right( widthInfo, len(widthInfo)-pos-1 )
					}
				}
			}
			
		if(unitX=="pm")
			{
			scaleX /= 1000
			unitX = "nm"
			}
	
		scaleY = scaleX	
		unitY = UnitX		
		}	
		
	if(Manufacturer=="AnalySIS")
		{
		unitX = "nm"
		unitY = "nm"
		imported.GetNumberNote(Manufacturer+":Pixel Size X", scaleX ) 
		imported.GetNumberNote(Manufacturer+":Pixel Size Y", scaleY) 	
		}
		
//result("\ncalX "+scaleX+" "+unitX)		
//result("\ncalY "+scaleY+" "+unitY)	
	if ( 0 < scaleX )
		{
		imported.ImageSetDimensionScale(0,scaleX)
		imported.ImageSetDimensionUnitString(0,unitX)
		}
	else if(OKcancelDialog("cannot read calibration in image "+Name)) exit(0)
	if ( 0 < scaleY )
		{
		imported.ImageSetDimensionScale(1,scaleY)
		imported.ImageSetDimensionUnitString(1,unitY)
		}
			
	return imported
	}
	
	
	
/**********************************************************************
Head importing commands
**********************************************************************/	
	
void OpenOneImage112( string path,string name)
	{
	image im
	string ext = PathExtractExtension(name,0)
	number recognized
	
	if(ext == "ser") 
		{
		im := ConvertSerImage112(path+name)
		im := ReshapeSerImage112(im)
		
		string TruncName = TrunctateFileExtension112( Name,3)	//remove "_1."
		im.imageSetName(TruncName)
		
		recognized =1
		}

	if(ext == "tif") 
		{
		try{
			im:= ImportTIFFWithTags112(path+name);
			recognized =1
			}
		catch{
result("\n"+name+ " TIFF tags cannot be identified, import failed")		
			break;
			}
		
		}
		
	if((ext == "dm3")||(ext == "dm4"))  
		{
		im:= openimage(path+Name)
		
		recognized =1
		}
	
	if(recognized)
		{	
		im.showimage()
		im.ImageGetImageDisplay(0).applydatabar(0)
		}
	}


/**********************************************************************
Opening
**********************************************************************/
	number all 
	if(ControlDown()) all=1
	
	string full,path,name,ext
	if (!OpenDialog(full)) exit(0);
	path = full.PathExtractDirectory(0)
//result("\nfull#"+full)	
	if(all==1)
		{
        TagGroup tg,tagi 
        tg = GetFilesInDirectory(path,3)
        number NoFiles = tg.TagGroupCountTags()
		for (number i=0; i<NoFiles; i++)
			{
			tg.TagGroupGetIndexedTagAsTagGroup(i,tagi)
			if(tagi.TagGroupGetTagAsString("Name",name))
				{
//result("\n"+name)
				OpenOneImage112(path,name)
				}
			}
		}
	else
		{		
		name = full.PathExtractFileName(0)
		ext = full.PathExtractExtension(0)	
		result("\n"+name)
		if(ext=="emi")	//allowed to click on emi instead of ser
			{
			name = TrunctateFileExtension112(name,1)+"_1.ser"
			}
//result("\npath #"+path+"# #"+name+"# #"+ext+"#")
		OpenOneImage112(path,name)			
		}	
	
	
